/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPCEventLTV;
import apicore.message.UUID;
import apicore.ptmp.PacketTracerSession;
import apiipc.generated.events.DHCPClientProcessEvent;
import apiipc.generated.events.DHCPClientProcessEventListener;
import apiipc.generated.sim.DHCPClientProcess;
import apiipc.ipc.IPCEventRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DHCPClientProcessEventRegistry
extends IPCEventRegistry {
    protected Set<DHCPClientProcessEventListener> globalListeners = new HashSet<DHCPClientProcessEventListener>();
    protected Map<String, Set<DHCPClientProcessEventListener>> specificObjectListeners = new HashMap<String, Set<DHCPClientProcessEventListener>>();

    public DHCPClientProcessEventRegistry(PacketTracerSession packetTracerSession) {
        super(packetTracerSession);
    }

    @Override
    public String getClassName() {
        return "DHCPClientProcess";
    }

    @Override
    public void processEvent(IPCEventLTV iPCEventLTV) {
        String string = iPCEventLTV.getEventName();
        DHCPClientProcessEvent dHCPClientProcessEvent = null;
        if (string.equalsIgnoreCase("dhcpSucceed")) {
            dHCPClientProcessEvent = new DHCPClientProcessEvent.DhcpSucceed(iPCEventLTV);
        } else if (string.equalsIgnoreCase("dhcpConfigured")) {
            dHCPClientProcessEvent = new DHCPClientProcessEvent.DhcpConfigured(iPCEventLTV);
        } else if (string.equalsIgnoreCase("dhcpFailed")) {
            dHCPClientProcessEvent = new DHCPClientProcessEvent.DhcpFailed(iPCEventLTV);
        } else {
            return;
        }
        for (DHCPClientProcessEventListener object : this.globalListeners) {
            object.handleEvent(dHCPClientProcessEvent);
        }
        Set<DHCPClientProcessEventListener> set = this.specificObjectListeners.get(dHCPClientProcessEvent.objectUUID.toString());
        if (set != null) {
            for (DHCPClientProcessEventListener dHCPClientProcessEventListener : set) {
                dHCPClientProcessEventListener.handleEvent(dHCPClientProcessEvent);
            }
        }
    }

    public void addListenerFiltered(DHCPClientProcessEventListener dHCPClientProcessEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.register("dhcpSucceed");
                this.register("dhcpConfigured");
                this.register("dhcpFailed");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        this.globalListeners.add(dHCPClientProcessEventListener);
    }

    public void addSpecificListenerFiltered(DHCPClientProcessEventListener dHCPClientProcessEventListener, DHCPClientProcess dHCPClientProcess, List<String> list) throws IOException {
        UUID uUID = dHCPClientProcess.getObjectUUID();
        String string = uUID.toString();
        Set<DHCPClientProcessEventListener> set = this.specificObjectListeners.get(string);
        if (set == null) {
            set = new HashSet<DHCPClientProcessEventListener>();
            this.specificObjectListeners.put(string, set);
            if (list == null) {
                this.register(uUID, "dhcpSucceed");
                this.register(uUID, "dhcpConfigured");
                this.register(uUID, "dhcpFailed");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(uUID, list.get(i));
                }
            }
        }
        set.add(dHCPClientProcessEventListener);
    }

    public void removeListenerFiltered(DHCPClientProcessEventListener dHCPClientProcessEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (list == null) {
                this.deregister("dhcpSucceed");
                this.deregister("dhcpConfigured");
                this.deregister("dhcpFailed");
            }
            this.globalListeners.remove(dHCPClientProcessEventListener);
        }
    }

    public void removeSpecificListenerFiltered(DHCPClientProcessEventListener dHCPClientProcessEventListener, DHCPClientProcess dHCPClientProcess, List<String> list) throws IOException {
        UUID uUID = dHCPClientProcess.getObjectUUID();
        String string = uUID.toString();
        Set<DHCPClientProcessEventListener> set = this.specificObjectListeners.get(string);
        if (set != null && !set.isEmpty()) {
            this.deregister(uUID, "dhcpSucceed");
            this.deregister(uUID, "dhcpConfigured");
            this.deregister(uUID, "dhcpFailed");
            set.remove(dHCPClientProcessEventListener);
        }
    }

    public void addListener(DHCPClientProcessEventListener dHCPClientProcessEventListener) throws IOException {
        this.addListenerFiltered(dHCPClientProcessEventListener, null);
    }

    public void addListener(DHCPClientProcessEventListener dHCPClientProcessEventListener, DHCPClientProcess dHCPClientProcess) throws IOException {
        this.addSpecificListenerFiltered(dHCPClientProcessEventListener, dHCPClientProcess, null);
    }

    public void removeListener(DHCPClientProcessEventListener dHCPClientProcessEventListener) throws IOException {
        this.removeListenerFiltered(dHCPClientProcessEventListener, null);
    }

    public void removeListener(DHCPClientProcessEventListener dHCPClientProcessEventListener, DHCPClientProcess dHCPClientProcess) throws IOException {
        this.removeSpecificListenerFiltered(dHCPClientProcessEventListener, dHCPClientProcess, null);
    }
}

